﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class RegistrantRetirementImporterTests
    {
        private RegistrantRetirementImporter _cut;
        #region setup
        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new RegistrantRetirementImporter();
        }
        #endregion
        [TestMethod]
        public void GetRetirementInfo_Should_Contain_Single_Registrant_Retirement_Entry()
        {
            Retirement expected = new Retirement();
            expected.edipi = "1023820699";
            expected.retirementData = new RetirementData();
            expected.retirementData.retirementBeginDate = new DateTime(2016, 12, 16);
            expected.retirementData.retirementTypeCode = "B";
            expected.retirementData.retirementTerminationReasonCode = "W";
            var edipi = "1023820699";
            var actualResponse = _cut.GetRetirementResponse(edipi);

            Assert.IsNotNull(actualResponse);
            Assert.AreEqual(1, actualResponse.retirement.Length);
        }

        [TestMethod]
        public void GetRetirementInfo_Retirement_Array_Should_Be_Null_If_Registrant_Not_Retired()
        {
            var edipi = "1293307390";
            var actualResponse = _cut.GetRetirementResponse(edipi);

            Assert.IsNotNull(actualResponse);
            Assert.IsNull(actualResponse.retirement);
        }
        //public void HoldingMethod()
        //{
        //    var actualRetirement = actualResponse.retirement[0].retirementData;
        //    Assert.AreEqual(expected.retirementData.retirementTypeCode, actualRetirement.retirementTypeCode);
        //    Assert.AreEqual(expected.retirementData.retirementBeginDate, actualRetirement.retirementBeginDate);
        //    Assert.AreEqual(expected.retirementData.retirementTerminationReasonCode, actualRetirement.retirementTerminationReasonCode);
        //}

    }
}
